/*
 * Decompiled with CFR 0.152.
 */
package com.br.modelo.model.controller;

import com.br.modelo.model.DTO.TrocaSenhaRequest;
import com.br.modelo.model.model.Usuario;
import com.br.modelo.model.repository.UsuarioRepository;
import com.br.modelo.model.service.TokenService;
import com.br.modelo.model.service.UsuarioService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auth"})
public class AuthController {
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private UsuarioRepository usuarioRepository;

    @PostMapping(value={"/login"})
    public Map<String, String> login(@RequestBody Usuario usuario) {
        this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)usuario.getLogin(), (Object)usuario.getSenha()));
        Usuario usuarioAutenticado = (Usuario)this.usuarioRepository.findByLogin(usuario.getLogin()).orElseThrow(() -> new RuntimeException("Usu\u00e1rio n\u00e3o encontrado"));
        String token = this.tokenService.generateToken(usuarioAutenticado);
        return Map.of("token", token);
    }

    @PostMapping(value={"/register"})
    public Map<String, String> register(@RequestBody Usuario usuario) {
        if (this.usuarioRepository.findByLogin(usuario.getLogin()).isPresent()) {
            throw new RuntimeException("Login j\u00e1 est\u00e1 em uso");
        }
        usuario.setSenha(this.passwordEncoder.encode((CharSequence)usuario.getSenha()));
        this.usuarioRepository.save((Object)usuario);
        return Map.of("message", "Usu\u00e1rio cadastrado com sucesso");
    }

    @PostMapping(value={"/validate-token"})
    public boolean validateToken(@RequestHeader(value="Authorization") String token) {
        String login = this.tokenService.validateToken(token.replace("Bearer ", ""));
        if (login == null) {
            return false;
        }
        return this.usuarioRepository.findByLogin(login).isPresent();
    }

    @PostMapping(value={"/logout"})
    public void logout(@RequestHeader(value="Authorization") String token) {
        this.tokenService.invalidateToken(token.replace("Bearer ", ""));
    }

    @PostMapping(value={"/trocar-senha"})
    public Map<String, String> trocarSenha(@RequestHeader(value="Authorization") String token, @RequestBody TrocaSenhaRequest request) {
        String login = this.tokenService.validateToken(token.replace("Bearer ", ""));
        Usuario usuario = (Usuario)this.usuarioRepository.findByLogin(login).orElseThrow(() -> new RuntimeException("Usu\u00e1rio n\u00e3o encontrado"));
        if (!this.passwordEncoder.matches((CharSequence)request.getSenhaAtual(), usuario.getSenha())) {
            throw new RuntimeException("Senha atual incorreta");
        }
        usuario.setSenha(this.passwordEncoder.encode((CharSequence)request.getNovaSenha()));
        this.usuarioRepository.save((Object)usuario);
        return Map.of("message", "Senha alterada com sucesso");
    }
}

