/*
 * Decompiled with CFR 0.152.
 */
package com.br.modelo.model.controller;

import com.br.modelo.model.model.Lanche;
import com.br.modelo.model.service.LancheService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/lanches"})
public class LancheController {
    @Autowired
    private LancheService lancheService;

    @GetMapping
    public List<Lanche> findAll() {
        return this.lancheService.findAll();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Lanche> findById(@PathVariable Long id) {
        return this.lancheService.findById(id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @PostMapping
    public Lanche save(@RequestBody Lanche lanche) {
        return this.lancheService.save(lanche);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteById(@PathVariable Long id) {
        this.lancheService.deleteById(id);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/restaurante/{restauranteId}"})
    public List<Lanche> findByRestauranteId(@PathVariable Long restauranteId) {
        return this.lancheService.findByRestauranteId(restauranteId);
    }

    @GetMapping(value={"/promocao"})
    public List<Lanche> findByPromocaoTrue() {
        return this.lancheService.findByPromocaoTrue();
    }

    @PostMapping(value={"/{lancheId}/tipos/{tipoId}"})
    public Lanche addTipoToLanche(@PathVariable Long lancheId, @PathVariable Long tipoId) {
        return this.lancheService.addTipoToLanche(lancheId, tipoId);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Lanche> update(@PathVariable Long id, @RequestBody Lanche lanche) {
        return this.lancheService.findById(id).map(existingLanche -> {
            lanche.setId(id);
            Lanche updatedLanche = this.lancheService.save(lanche);
            return ResponseEntity.ok((Object)updatedLanche);
        }).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/{id}/detalhes"})
    public ResponseEntity<Map<String, Object>> findLancheWithTipoIds(@PathVariable Long id) {
        return this.lancheService.findById(id).map(lanche -> {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("lanche", lanche);
            response.put("tipoIds", lanche.getTipos().stream().map(tipo -> tipo.getId()).collect(Collectors.toList()));
            return ResponseEntity.ok(response);
        }).orElse(ResponseEntity.notFound().build());
    }

    @PostMapping(value={"/{id}/upload-imagem"})
    public ResponseEntity<String> uploadImagem(@PathVariable Long id, @RequestParam(value="file") MultipartFile file) {
        try {
            String caminhoImagem = this.lancheService.salvarImagem(id, file);
            return ResponseEntity.ok((Object)("Imagem salva com sucesso: " + caminhoImagem));
        }
        catch (IOException e) {
            return ResponseEntity.status((int)500).body((Object)("Erro ao salvar a imagem: " + e.getMessage()));
        }
    }
}

