/*
 * Decompiled with CFR 0.152.
 */
package com.br.modelo.model.controller;

import com.br.modelo.model.model.Restaurante;
import com.br.modelo.model.service.RestauranteService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restaurantes"})
public class RestauranteController {
    @Autowired
    private RestauranteService restauranteService;

    @GetMapping
    public List<Restaurante> findAll() {
        return this.restauranteService.findAll();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Restaurante> findById(@PathVariable Long id) {
        return this.restauranteService.findById(id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @PostMapping
    public Restaurante save(@RequestBody Restaurante restaurante) {
        return this.restauranteService.save(restaurante);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteById(@PathVariable Long id) {
        this.restauranteService.deleteById(id);
        return ResponseEntity.noContent().build();
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Restaurante> atualizarRestaurante(@PathVariable Long id, @RequestBody Restaurante restaurante) {
        Restaurante atualizado = this.restauranteService.atualizarRestaurante(id, restaurante);
        return ResponseEntity.ok((Object)atualizado);
    }
}

