/*
 * Decompiled with CFR 0.152.
 */
package com.br.modelo.model.controller;

import com.br.modelo.model.model.Tipo;
import com.br.modelo.model.service.TipoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tipos"})
public class TipoController {
    @Autowired
    private TipoService tipoService;

    @GetMapping
    public List<Tipo> findAll() {
        return this.tipoService.findAll();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Tipo> findById(@PathVariable Long id) {
        return this.tipoService.findById(id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @PostMapping
    public Tipo save(@RequestBody Tipo tipo) {
        return this.tipoService.save(tipo);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteById(@PathVariable Long id) {
        this.tipoService.deleteById(id);
        return ResponseEntity.noContent().build();
    }
}

