/*
 * Decompiled with CFR 0.152.
 */
package com.br.modelo.model.security;

import com.br.modelo.model.model.Usuario;
import com.br.modelo.model.repository.UsuarioRepository;
import com.br.modelo.model.security.SecurityFilter;
import jakarta.servlet.Filter;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

@Configuration
public class SecurityConfig {
    @Autowired
    SecurityFilter securityFilter;

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity httpSecurity) throws Exception {
        return (SecurityFilterChain)httpSecurity.csrf(csrf -> csrf.disable()).cors(cors -> cors.configure((HttpSecurityBuilder)httpSecurity)).sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(HttpMethod.POST, new String[]{"/auth/login"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{"/auth/register"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/lanches/**"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/restaurantes/**"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/tipos/**"})).permitAll().anyRequest()).authenticated()).addFilterBefore((Filter)this.securityFilter, UsernamePasswordAuthenticationFilter.class).build();
    }

    @Bean
    public AuthenticationManager authenticationManager(UsuarioRepository usuarioRepository, PasswordEncoder passwordEncoder) {
        DaoAuthenticationProvider authenticationProvider = new DaoAuthenticationProvider();
        authenticationProvider.setUserDetailsService(login -> {
            Usuario usuario = (Usuario)usuarioRepository.findByLogin(login).orElseThrow(() -> new UsernameNotFoundException("Usu\u00e1rio n\u00e3o encontrado"));
            return new User(usuario.getLogin(), usuario.getSenha(), Collections.emptyList());
        });
        authenticationProvider.setPasswordEncoder(passwordEncoder);
        return new ProviderManager(new AuthenticationProvider[]{authenticationProvider});
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }
}

