/*
 * Decompiled with CFR 0.152.
 */
package com.br.modelo.model.service;

import com.br.modelo.model.model.Lanche;
import com.br.modelo.model.model.Tipo;
import com.br.modelo.model.repository.LancheRepository;
import com.br.modelo.model.repository.TipoRepository;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import net.coobird.thumbnailator.Thumbnails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class LancheService {
    @Autowired
    private LancheRepository lancheRepository;
    @Autowired
    private TipoRepository tipoRepository;

    public List<Lanche> findAll() {
        return this.lancheRepository.findAll();
    }

    public Optional<Lanche> findById(Long id) {
        return this.lancheRepository.findById((Object)id);
    }

    public Lanche save(Lanche lanche) {
        return (Lanche)this.lancheRepository.save((Object)lanche);
    }

    public void deleteById(Long id) {
        this.lancheRepository.deleteById((Object)id);
    }

    public List<Lanche> findByRestauranteId(Long restauranteId) {
        return this.lancheRepository.findByRestauranteId(restauranteId);
    }

    public List<Lanche> findByPromocaoTrue() {
        return this.lancheRepository.findByPromocaoTrue();
    }

    public Lanche addTipoToLanche(Long lancheId, Long tipoId) {
        Lanche lanche = (Lanche)this.lancheRepository.findById((Object)lancheId).orElseThrow(() -> new RuntimeException("Lanche n\u00e3o encontrado"));
        Tipo tipo = (Tipo)this.tipoRepository.findById((Object)tipoId).orElseThrow(() -> new RuntimeException("Tipo n\u00e3o encontrado"));
        lanche.getTipos().add(tipo);
        return (Lanche)this.lancheRepository.save((Object)lanche);
    }

    public String salvarImagem(Long id, MultipartFile file) throws IOException {
        if (file.getSize() > 0xA00000L) {
            throw new RuntimeException("Arquivo muito grande. O tamanho m\u00e1ximo permitido \u00e9 10MB.");
        }
        Lanche lanche = (Lanche)this.lancheRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Lanche n\u00e3o encontrado"));
        String diretorio = "D:\\Biblioteca\\Documentos\\GitHub\\Restaurante\\Modelo\\front-webmenu\\public\\images";
        Path caminho = Paths.get(diretorio, file.getOriginalFilename());
        if (Files.exists(caminho, new LinkOption[0])) {
            Files.delete(caminho);
        }
        File arquivoReduzido = new File(diretorio, file.getOriginalFilename());
        Thumbnails.of((InputStream[])new InputStream[]{file.getInputStream()}).size(640, Integer.MAX_VALUE).outputQuality(0.9).toFile(arquivoReduzido);
        String imagemUrl = "/images/" + file.getOriginalFilename();
        lanche.setImagemUrl(imagemUrl);
        this.lancheRepository.save((Object)lanche);
        return imagemUrl;
    }
}

