/*
 * Decompiled with CFR 0.152.
 */
package com.br.modelo.model.service;

import com.br.modelo.model.model.Restaurante;
import com.br.modelo.model.repository.RestauranteRepository;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RestauranteService {
    @Autowired
    private RestauranteRepository restauranteRepository;

    public List<Restaurante> findAll() {
        return this.restauranteRepository.findAll();
    }

    public Optional<Restaurante> findById(Long id) {
        return this.restauranteRepository.findById((Object)id);
    }

    public Restaurante save(Restaurante restaurante) {
        return (Restaurante)this.restauranteRepository.save((Object)restaurante);
    }

    public void deleteById(Long id) {
        this.restauranteRepository.deleteById((Object)id);
    }

    @Transactional
    public Restaurante atualizarRestaurante(Long id, Restaurante novosDados) {
        return this.restauranteRepository.findById((Object)id).map(restauranteExistente -> {
            restauranteExistente.setNome(novosDados.getNome());
            restauranteExistente.setTelefone(novosDados.getTelefone());
            restauranteExistente.setEndereco(novosDados.getEndereco());
            restauranteExistente.setCorHeader(novosDados.getCorHeader());
            restauranteExistente.setCorFonte(novosDados.getCorFonte());
            restauranteExistente.setInstagram(novosDados.getInstagram());
            restauranteExistente.setLinkMaps(novosDados.getLinkMaps());
            if (novosDados.getHorariosFuncionamento() != null) {
                restauranteExistente.getHorariosFuncionamento().clear();
                novosDados.getHorariosFuncionamento().forEach(horario -> {
                    horario.setRestaurante(restauranteExistente);
                    restauranteExistente.getHorariosFuncionamento().add(horario);
                });
            }
            return (Restaurante)this.restauranteRepository.save(restauranteExistente);
        }).orElseThrow(() -> new RuntimeException("Restaurante n\u00e3o encontrado!"));
    }
}

