/*
 * Decompiled with CFR 0.152.
 */
package com.br.modelo.model.service;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.br.modelo.model.model.Usuario;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    @Value(value="${api.security.token.secret}")
    private String secret;
    private Set<String> blacklistedTokens = new HashSet();

    public String generateToken(Usuario user) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)this.secret);
            return JWT.create().withIssuer("auth-api").withClaim("id", user.getId()).withClaim("login", user.getLogin()).withExpiresAt(this.genExpirationDate()).sign(algorithm);
        }
        catch (JWTCreationException exception) {
            throw new RuntimeException("Erro ao gerar token", exception);
        }
    }

    public String validateToken(String token) {
        if (this.blacklistedTokens.contains(token)) {
            return null;
        }
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)this.secret);
            return JWT.require((Algorithm)algorithm).withIssuer("auth-api").build().verify(token).getClaim("login").asString();
        }
        catch (JWTVerificationException exception) {
            return null;
        }
    }

    public void invalidateToken(String token) {
        this.blacklistedTokens.add(token);
    }

    private Instant genExpirationDate() {
        return LocalDateTime.now().plusDays(30L).toInstant(ZoneOffset.of("-03:00"));
    }
}

