/*
 * Decompiled with CFR 0.152.
 */
package com.br.modelo.model.service;

import com.br.modelo.model.model.Usuario;
import com.br.modelo.model.repository.UsuarioRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UsuarioService {
    @Autowired
    private UsuarioRepository usuarioRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;

    public List<Usuario> listarTodos() {
        return this.usuarioRepository.findAll();
    }

    public Optional<Usuario> buscarPorId(Long id) {
        return this.usuarioRepository.findById((Object)id);
    }

    public Optional<Usuario> buscarPorLogin(String login) {
        return this.usuarioRepository.findByLogin(login);
    }

    public Usuario salvar(Usuario usuario) {
        usuario.setSenha(this.passwordEncoder.encode((CharSequence)usuario.getSenha()));
        return (Usuario)this.usuarioRepository.save((Object)usuario);
    }

    public Usuario atualizar(Long id, Usuario usuarioAtualizado) {
        return this.usuarioRepository.findById((Object)id).map(usuario -> {
            usuario.setNome(usuarioAtualizado.getNome());
            usuario.setLogin(usuarioAtualizado.getLogin());
            if (!this.passwordEncoder.matches((CharSequence)usuarioAtualizado.getSenha(), usuario.getSenha())) {
                usuario.setSenha(this.passwordEncoder.encode((CharSequence)usuarioAtualizado.getSenha()));
            }
            return (Usuario)this.usuarioRepository.save(usuario);
        }).orElseThrow(() -> new RuntimeException("Usu\u00e1rio n\u00e3o encontrado!"));
    }

    public void deletar(Long id) {
        this.usuarioRepository.deleteById((Object)id);
    }

    public Usuario registrarUsuario(Usuario usuario) {
        usuario.setSenha(this.passwordEncoder.encode((CharSequence)usuario.getSenha()));
        return (Usuario)this.usuarioRepository.save((Object)usuario);
    }
}

